$syncFieldMap = @{
	fname = 'GivenName'
	lname = 'Surname'
	dept  = 'Department'
}

$fieldMatchIds = @{
	AD  = @('givenName', 'surName')
	CSV = @('fname', 'lname')
}

function Get-AcmeEmployeeFromCsv {
	[CmdletBinding()]
	param
	(
		[Parameter()]
		[ValidateNotNullOrEmpty()]
		[string]$CsvFilePath = 'C:\Employees.csv'
	)
	try {
		## Mapuje właściwości z pliku CSV na odpowiadające im właściwości AD
		$properties = $syncFieldMap.GetEnumerator() | ForEach-Object {
			@{
				Name       = $_.Value
				Expression = [scriptblock]::Create("`$_.$($_.Key)")
			}
		}

		## Generuje unikatowy identyfikator i tworzy z niego właściwość
		$uniqueIdProperty = '"{0}{1}" -f '
		$uniqueIdProperty = $uniqueIdProperty += ($fieldMatchIds.CSV | ForEach-Object { '$_.{0}' -f $_ }) -join ','

		$properties += @{
			Name       = 'UniqueID'
			Expression = [scriptblock]::Create($uniqueIdProperty)
		}

		## Odczytuje zawartość pliku CSV przekształca pola CSV na odpowiadające im właściwości
		Import-Csv -Path $CsvFilePath | Select-Object -Property $properties

	} catch {
		Write-Error -Message $_.Exception.Message
	}
}

function Get-AcmeEmployeeFromAD {
	[CmdletBinding()]
	param
	()

	try {
		$uniqueIdProperty = '"{0}{1}" -f '
		$uniqueIdProperty += ($fieldMatchIds.AD | ForEach-Object { '$_.{0}' -f $_ }) -join ','

		$uniqueIdProperty = @{
			Name       = 'UniqueID'
			Expression = [scriptblock]::Create($uniqueIdProperty)
		}

		Get-AdUser -Filter * -Properties @($syncFieldMap.Values) | Select-Object *, $uniqueIdProperty

	} catch {
		Write-Error -Message $_.Exception.Message
	}
}

function Find-UserMatch {
	[OutputType()]
	[CmdletBinding()]
	param
	(
		[Parameter()]
		[ValidateNotNullOrEmpty()]
		[object[]]$AdUsers = (Get-AcmeEmployeeFromAD),

		[Parameter()]
		[ValidateNotNullOrEmpty()]
		[object]$CsvUsers = (Get-AcmeEmployeeFromCsv)
	)

	$AdUsers.foreach({
			$adUniqueId = $_.UniqueID
			if ($adUniqueId) {
				$output = @{
					CSVProperties    = 'NoMatch'
					ADSamAccountName = $_.samAccountName
				}
				if ($adUniqueId -in $CsvUsers.UniqueId) {
					$output.CSVProperties = ($CsvUsers.Where({ $_.UniqueId -eq $adUniqueId}))
				}
				[pscustomobject]$output
			}
		})
}

## Wyszukuje wszystkie dopasowania: plik CSV <--> konto użytkownika Active Directory
$positiveMatches = (Find-UserMatch).where({ $_.CSVProperties -ne 'NoMatch' })
foreach ($positiveMatch in $positiveMatches) {
	## Tworzy parametry dla polecenia Set-ADUser używając atrybutu samAccountName z AD jako identyfikatora konta
	$setAdUserParams = @{
		Identity = $positiveMatch.ADSamAccountName
	}

	## Odczytuje wartości tych właściwości, które są wymienione w pliku CSV file
	$positiveMatch.CSVProperties.foreach({
			## Dodaje odpowiedni parameter polecenia Set-ADUser dla wszystkich właściwości
			$_.PSObject.Properties.where({ $_.Name -ne 'UniqueID' }).foreach({
					$setAdUserParams[$_.Name] = $_.Value
				})
		})
	Set-AdUser @setAdUserParams
}